using System;
using System.Collections;
using System.ComponentModel;
using System.Data;
using System.Drawing;

using System.Windows.Forms;


namespace gov.va.med.vbecs.GUI
{
	/// <summary>
	/// Class DlgOrderDetails
	/// </summary>
	public class DlgOrderDetails : gov.va.med.vbecs.GUI.VbecsBaseForm
	{
		private System.Windows.Forms.Label label10;
		private System.Windows.Forms.Label label9;
		private System.Windows.Forms.Label label11;
		private System.Windows.Forms.Label label12;
		private System.Windows.Forms.Label label18;
		private System.Windows.Forms.GroupBox groupBox1;
		private System.Windows.Forms.GroupBox groupBox2;
		private System.Windows.Forms.Label label1;
		private System.Windows.Forms.Label label3;
		private System.Windows.Forms.Label label4;
		private System.Windows.Forms.ColumnHeader colTestName;
		private System.Windows.Forms.ColumnHeader colResult;
		private System.Windows.Forms.Button btnOK;
		private System.Windows.Forms.Label label5;
		private System.Windows.Forms.Label label6;
		private System.Windows.Forms.Label label7;
		private System.Windows.Forms.PictureBox pictureBox1;
		private System.Windows.Forms.Label label8;
		private System.Windows.Forms.Label label13;
		private System.Windows.Forms.Label label14;
		private System.Windows.Forms.Panel pnlComponentClass;
		private System.Windows.Forms.GroupBox grpOrderedProcedure;
		private System.Windows.Forms.ListView lvPreviousResults;
		private System.Windows.Forms.ColumnHeader colDateTime;
		private System.Windows.Forms.Label label16;
		private System.Windows.Forms.GroupBox grpOrderCheck;
		private System.Windows.Forms.Label label17;
		private System.Windows.Forms.Label label19;
		private System.Windows.Forms.Label label20;
		private System.Windows.Forms.Label label22;
		private System.Windows.Forms.Label label23;
		private System.Windows.Forms.Label label21;
		private System.Windows.Forms.Label label24;
		private System.Windows.Forms.Label label26;
		private System.Windows.Forms.Label label25;
		private System.Windows.Forms.TextBox txtDateTimeWanted;
		private System.Windows.Forms.TextBox txtOrderingHospitalLocation;
		private System.Windows.Forms.TextBox txtDateTimeOrdered;
		private System.Windows.Forms.TextBox txtOrderingClinician;
		private System.Windows.Forms.TextBox txtSpecimenStatus;
		private System.Windows.Forms.TextBox txtUrgency;
		private System.Windows.Forms.TextBox txtOrderComments;
		private System.Windows.Forms.TextBox txtDiagnosticText;
		private System.Windows.Forms.TextBox txtSpecimenUID;
		private System.Windows.Forms.TextBox txtOrderEnteredBy;
		private System.Windows.Forms.TextBox txtCPRSOrderID;
		private System.Windows.Forms.TextBox txtInformedConsent;
		private System.Windows.Forms.TextBox txtLabOrderID;
		private System.Windows.Forms.TextBox txtDiagnosis;
		private System.Windows.Forms.TextBox txtDivision;
		private System.Windows.Forms.TextBox txtPatientTreating;
		private System.Windows.Forms.TextBox txtReason;
		private System.Windows.Forms.Panel pnlOrderedTest;
		private System.Windows.Forms.TextBox txtComponent;
		private System.Windows.Forms.TextBox txtQuantity;
		private System.Windows.Forms.TextBox txtRequirements;
		private System.Windows.Forms.TextBox txtUrgencyComponent;
		private System.Windows.Forms.TextBox txtComments;
		private System.Windows.Forms.TextBox txtSurgeryName;
		private System.Windows.Forms.TextBox txtDateTimeWantedComponent;
		private System.Windows.Forms.Label lblLabOrderNo;
		private System.Windows.Forms.TextBox txtLabOrderNo;
		private System.ComponentModel.IContainer components = null;

		/// <summary>
		/// Constructor
		/// </summary>
		public DlgOrderDetails()
		{
			// This call is required by the Windows Form Designer.
			InitializeComponent();
		}

		/// <summary>
		/// Constructor
		/// </summary>
		/// <param name="patientOrder"></param>
		public DlgOrderDetails(BOL.PatientOrder patientOrder)
		{		
			// This call is required by the Windows Form Designer.
			InitializeComponent();

			this.SetThisHelpFile(this, Common.StrRes.HelpFiles.UC016.DlgOrderDetails());

			if (patientOrder != null)
			{
				SetComponentProperties(patientOrder);
				PopulateListView(patientOrder);
			}
			this.txtDiagnosticText.Focus();
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			System.Resources.ResourceManager resources = new System.Resources.ResourceManager(typeof(DlgOrderDetails));
			this.txtComponent = new System.Windows.Forms.TextBox();
			this.txtOrderEnteredBy = new System.Windows.Forms.TextBox();
			this.txtDateTimeWanted = new System.Windows.Forms.TextBox();
			this.txtOrderingHospitalLocation = new System.Windows.Forms.TextBox();
			this.txtQuantity = new System.Windows.Forms.TextBox();
			this.label10 = new System.Windows.Forms.Label();
			this.label9 = new System.Windows.Forms.Label();
			this.label11 = new System.Windows.Forms.Label();
			this.label12 = new System.Windows.Forms.Label();
			this.txtCPRSOrderID = new System.Windows.Forms.TextBox();
			this.label18 = new System.Windows.Forms.Label();
			this.groupBox1 = new System.Windows.Forms.GroupBox();
			this.pictureBox1 = new System.Windows.Forms.PictureBox();
			this.groupBox2 = new System.Windows.Forms.GroupBox();
			this.txtLabOrderNo = new System.Windows.Forms.TextBox();
			this.lblLabOrderNo = new System.Windows.Forms.Label();
			this.txtInformedConsent = new System.Windows.Forms.TextBox();
			this.label25 = new System.Windows.Forms.Label();
			this.label19 = new System.Windows.Forms.Label();
			this.txtDateTimeOrdered = new System.Windows.Forms.TextBox();
			this.txtOrderingClinician = new System.Windows.Forms.TextBox();
			this.label17 = new System.Windows.Forms.Label();
			this.txtSurgeryName = new System.Windows.Forms.TextBox();
			this.txtLabOrderID = new System.Windows.Forms.TextBox();
			this.txtDiagnosis = new System.Windows.Forms.TextBox();
			this.txtDivision = new System.Windows.Forms.TextBox();
			this.txtPatientTreating = new System.Windows.Forms.TextBox();
			this.label7 = new System.Windows.Forms.Label();
			this.txtReason = new System.Windows.Forms.TextBox();
			this.label4 = new System.Windows.Forms.Label();
			this.label3 = new System.Windows.Forms.Label();
			this.label1 = new System.Windows.Forms.Label();
			this.label14 = new System.Windows.Forms.Label();
			this.txtSpecimenStatus = new System.Windows.Forms.TextBox();
			this.txtRequirements = new System.Windows.Forms.TextBox();
			this.label8 = new System.Windows.Forms.Label();
			this.label6 = new System.Windows.Forms.Label();
			this.label5 = new System.Windows.Forms.Label();
			this.lvPreviousResults = new System.Windows.Forms.ListView();
			this.colTestName = new System.Windows.Forms.ColumnHeader();
			this.colResult = new System.Windows.Forms.ColumnHeader();
			this.colDateTime = new System.Windows.Forms.ColumnHeader();
			this.label13 = new System.Windows.Forms.Label();
			this.btnOK = new System.Windows.Forms.Button();
			this.pnlComponentClass = new System.Windows.Forms.Panel();
			this.label26 = new System.Windows.Forms.Label();
			this.txtDateTimeWantedComponent = new System.Windows.Forms.TextBox();
			this.txtUrgencyComponent = new System.Windows.Forms.TextBox();
			this.label21 = new System.Windows.Forms.Label();
			this.txtComments = new System.Windows.Forms.TextBox();
			this.label22 = new System.Windows.Forms.Label();
			this.grpOrderedProcedure = new System.Windows.Forms.GroupBox();
			this.pnlOrderedTest = new System.Windows.Forms.Panel();
			this.txtUrgency = new System.Windows.Forms.TextBox();
			this.txtOrderComments = new System.Windows.Forms.TextBox();
			this.label23 = new System.Windows.Forms.Label();
			this.txtDiagnosticText = new System.Windows.Forms.TextBox();
			this.label16 = new System.Windows.Forms.Label();
			this.txtSpecimenUID = new System.Windows.Forms.TextBox();
			this.label20 = new System.Windows.Forms.Label();
			this.label24 = new System.Windows.Forms.Label();
			this.grpOrderCheck = new System.Windows.Forms.GroupBox();
			this.groupBox1.SuspendLayout();
			this.groupBox2.SuspendLayout();
			this.pnlComponentClass.SuspendLayout();
			this.grpOrderedProcedure.SuspendLayout();
			this.pnlOrderedTest.SuspendLayout();
			this.grpOrderCheck.SuspendLayout();
			this.SuspendLayout();
			// 
			// vbecsLogo1
			// 
			this.vbecsLogo1.Name = "vbecsLogo1";
			this.vbecsLogo1.Size = new System.Drawing.Size(720, 30);
			this.vbecsLogo1.TabIndex = 4;
			this.vbecsLogo1.Title = "Order Details";
			// 
			// lblRequiredField
			// 
			this.lblRequiredField.Location = new System.Drawing.Point(0, 405);
			this.lblRequiredField.Name = "lblRequiredField";
			this.lblRequiredField.TabIndex = 6;
			// 
			// txtComponent
			// 
			this.txtComponent.AccessibleDescription = "Component Class";
			this.txtComponent.AccessibleName = "Component Class";
			this.txtComponent.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.txtComponent.Location = new System.Drawing.Point(124, 0);
			this.txtComponent.Name = "txtComponent";
			this.txtComponent.ReadOnly = true;
			this.txtComponent.Size = new System.Drawing.Size(190, 20);
			this.txtComponent.TabIndex = 1;
			this.txtComponent.Text = "";
			// 
			// txtOrderEnteredBy
			// 
			this.txtOrderEnteredBy.AccessibleDescription = "Order Entered By";
			this.txtOrderEnteredBy.AccessibleName = "Order Entered By";
			this.txtOrderEnteredBy.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.txtOrderEnteredBy.Location = new System.Drawing.Point(140, 88);
			this.txtOrderEnteredBy.Name = "txtOrderEnteredBy";
			this.txtOrderEnteredBy.ReadOnly = true;
			this.txtOrderEnteredBy.ScrollBars = System.Windows.Forms.ScrollBars.Horizontal;
			this.txtOrderEnteredBy.Size = new System.Drawing.Size(182, 20);
			this.txtOrderEnteredBy.TabIndex = 7;
			this.txtOrderEnteredBy.Text = "";
			// 
			// txtDateTimeWanted
			// 
			this.txtDateTimeWanted.AccessibleDescription = "Date/Time Wanted";
			this.txtDateTimeWanted.AccessibleName = "Date/Time Wanted";
			this.txtDateTimeWanted.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.txtDateTimeWanted.Location = new System.Drawing.Point(124, 96);
			this.txtDateTimeWanted.Name = "txtDateTimeWanted";
			this.txtDateTimeWanted.ReadOnly = true;
			this.txtDateTimeWanted.ScrollBars = System.Windows.Forms.ScrollBars.Horizontal;
			this.txtDateTimeWanted.Size = new System.Drawing.Size(192, 20);
			this.txtDateTimeWanted.TabIndex = 7;
			this.txtDateTimeWanted.Text = "";
			// 
			// txtOrderingHospitalLocation
			// 
			this.txtOrderingHospitalLocation.AccessibleDescription = "Ordering Division";
			this.txtOrderingHospitalLocation.AccessibleName = "Ordering Division";
			this.txtOrderingHospitalLocation.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.txtOrderingHospitalLocation.Location = new System.Drawing.Point(140, 40);
			this.txtOrderingHospitalLocation.Name = "txtOrderingHospitalLocation";
			this.txtOrderingHospitalLocation.ReadOnly = true;
			this.txtOrderingHospitalLocation.ScrollBars = System.Windows.Forms.ScrollBars.Horizontal;
			this.txtOrderingHospitalLocation.Size = new System.Drawing.Size(182, 20);
			this.txtOrderingHospitalLocation.TabIndex = 3;
			this.txtOrderingHospitalLocation.Text = "";
			// 
			// txtQuantity
			// 
			this.txtQuantity.AccessibleDescription = "Quantity";
			this.txtQuantity.AccessibleName = "Quantity";
			this.txtQuantity.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.txtQuantity.Location = new System.Drawing.Point(124, 24);
			this.txtQuantity.Name = "txtQuantity";
			this.txtQuantity.ReadOnly = true;
			this.txtQuantity.Size = new System.Drawing.Size(190, 20);
			this.txtQuantity.TabIndex = 3;
			this.txtQuantity.Text = "";
			// 
			// label10
			// 
			this.label10.Location = new System.Drawing.Point(8, 40);
			this.label10.Name = "label10";
			this.label10.Size = new System.Drawing.Size(144, 23);
			this.label10.TabIndex = 2;
			this.label10.Text = "Ordering Division";
			this.label10.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// label9
			// 
			this.label9.Location = new System.Drawing.Point(8, 88);
			this.label9.Name = "label9";
			this.label9.Size = new System.Drawing.Size(93, 23);
			this.label9.TabIndex = 6;
			this.label9.Text = "Order Entered By";
			this.label9.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// label11
			// 
			this.label11.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.label11.Location = new System.Drawing.Point(8, 160);
			this.label11.Name = "label11";
			this.label11.Size = new System.Drawing.Size(112, 23);
			this.label11.TabIndex = 12;
			this.label11.Text = "VBECS Order ID";
			this.label11.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// label12
			// 
			this.label12.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.label12.Location = new System.Drawing.Point(8, 112);
			this.label12.Name = "label12";
			this.label12.Size = new System.Drawing.Size(136, 23);
			this.label12.TabIndex = 8;
			this.label12.Text = "CPRS Order ID";
			this.label12.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// txtCPRSOrderID
			// 
			this.txtCPRSOrderID.AccessibleDescription = "CPRS Order ID";
			this.txtCPRSOrderID.AccessibleName = "CPRS Order ID";
			this.txtCPRSOrderID.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.txtCPRSOrderID.Location = new System.Drawing.Point(140, 112);
			this.txtCPRSOrderID.Name = "txtCPRSOrderID";
			this.txtCPRSOrderID.ReadOnly = true;
			this.txtCPRSOrderID.ScrollBars = System.Windows.Forms.ScrollBars.Horizontal;
			this.txtCPRSOrderID.Size = new System.Drawing.Size(182, 20);
			this.txtCPRSOrderID.TabIndex = 9;
			this.txtCPRSOrderID.Text = "";
			// 
			// label18
			// 
			this.label18.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.label18.Location = new System.Drawing.Point(8, 184);
			this.label18.Name = "label18";
			this.label18.Size = new System.Drawing.Size(136, 23);
			this.label18.TabIndex = 14;
			this.label18.Text = "Patient Treating Specialty";
			this.label18.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// groupBox1
			// 
			this.groupBox1.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left)));
			this.groupBox1.Controls.Add(this.pictureBox1);
			this.groupBox1.Location = new System.Drawing.Point(4, 32);
			this.groupBox1.Name = "groupBox1";
			this.groupBox1.Size = new System.Drawing.Size(52, 345);
			this.groupBox1.TabIndex = 5;
			this.groupBox1.TabStop = false;
			// 
			// pictureBox1
			// 
			this.pictureBox1.Image = ((System.Drawing.Image)(resources.GetObject("pictureBox1.Image")));
			this.pictureBox1.Location = new System.Drawing.Point(4, 12);
			this.pictureBox1.Name = "pictureBox1";
			this.pictureBox1.Size = new System.Drawing.Size(45, 45);
			this.pictureBox1.SizeMode = System.Windows.Forms.PictureBoxSizeMode.AutoSize;
			this.pictureBox1.TabIndex = 0;
			this.pictureBox1.TabStop = false;
			// 
			// groupBox2
			// 
			this.groupBox2.AccessibleDescription = "Order Details";
			this.groupBox2.AccessibleName = "Order Details";
			this.groupBox2.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.groupBox2.Controls.Add(this.txtLabOrderNo);
			this.groupBox2.Controls.Add(this.lblLabOrderNo);
			this.groupBox2.Controls.Add(this.txtInformedConsent);
			this.groupBox2.Controls.Add(this.label25);
			this.groupBox2.Controls.Add(this.label19);
			this.groupBox2.Controls.Add(this.txtDateTimeOrdered);
			this.groupBox2.Controls.Add(this.txtOrderingClinician);
			this.groupBox2.Controls.Add(this.label17);
			this.groupBox2.Controls.Add(this.txtSurgeryName);
			this.groupBox2.Controls.Add(this.txtLabOrderID);
			this.groupBox2.Controls.Add(this.txtDiagnosis);
			this.groupBox2.Controls.Add(this.txtDivision);
			this.groupBox2.Controls.Add(this.txtPatientTreating);
			this.groupBox2.Controls.Add(this.label7);
			this.groupBox2.Controls.Add(this.txtReason);
			this.groupBox2.Controls.Add(this.label4);
			this.groupBox2.Controls.Add(this.label3);
			this.groupBox2.Controls.Add(this.label1);
			this.groupBox2.Controls.Add(this.txtOrderingHospitalLocation);
			this.groupBox2.Controls.Add(this.txtOrderEnteredBy);
			this.groupBox2.Controls.Add(this.txtCPRSOrderID);
			this.groupBox2.Controls.Add(this.label10);
			this.groupBox2.Controls.Add(this.label9);
			this.groupBox2.Controls.Add(this.label18);
			this.groupBox2.Controls.Add(this.label12);
			this.groupBox2.Controls.Add(this.label11);
			this.groupBox2.Location = new System.Drawing.Point(388, 32);
			this.groupBox2.Name = "groupBox2";
			this.groupBox2.Size = new System.Drawing.Size(328, 345);
			this.groupBox2.TabIndex = 3;
			this.groupBox2.TabStop = false;
			this.groupBox2.Text = "Order Details";
			// 
			// txtLabOrderNo
			// 
			this.txtLabOrderNo.AccessibleDescription = "Lab Order Number";
			this.txtLabOrderNo.AccessibleName = "Lab Order Number";
			this.txtLabOrderNo.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.txtLabOrderNo.Location = new System.Drawing.Point(140, 136);
			this.txtLabOrderNo.Name = "txtLabOrderNo";
			this.txtLabOrderNo.ReadOnly = true;
			this.txtLabOrderNo.ScrollBars = System.Windows.Forms.ScrollBars.Horizontal;
			this.txtLabOrderNo.Size = new System.Drawing.Size(182, 20);
			this.txtLabOrderNo.TabIndex = 11;
			this.txtLabOrderNo.Text = "";
			// 
			// lblLabOrderNo
			// 
			this.lblLabOrderNo.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.lblLabOrderNo.Location = new System.Drawing.Point(8, 136);
			this.lblLabOrderNo.Name = "lblLabOrderNo";
			this.lblLabOrderNo.Size = new System.Drawing.Size(112, 23);
			this.lblLabOrderNo.TabIndex = 10;
			this.lblLabOrderNo.Text = "Lab Order Number";
			this.lblLabOrderNo.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// txtInformedConsent
			// 
			this.txtInformedConsent.AccessibleDescription = "Informed Consent";
			this.txtInformedConsent.AccessibleName = "Informed Consent";
			this.txtInformedConsent.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.txtInformedConsent.Location = new System.Drawing.Point(140, 280);
			this.txtInformedConsent.Name = "txtInformedConsent";
			this.txtInformedConsent.ReadOnly = true;
			this.txtInformedConsent.ScrollBars = System.Windows.Forms.ScrollBars.Horizontal;
			this.txtInformedConsent.Size = new System.Drawing.Size(182, 20);
			this.txtInformedConsent.TabIndex = 23;
			this.txtInformedConsent.Text = "";
			// 
			// label25
			// 
			this.label25.Location = new System.Drawing.Point(8, 280);
			this.label25.Name = "label25";
			this.label25.Size = new System.Drawing.Size(132, 23);
			this.label25.TabIndex = 22;
			this.label25.Text = "Informed Consent?";
			this.label25.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// label19
			// 
			this.label19.Location = new System.Drawing.Point(8, 64);
			this.label19.Name = "label19";
			this.label19.Size = new System.Drawing.Size(104, 23);
			this.label19.TabIndex = 4;
			this.label19.Text = "Date/Time Ordered";
			this.label19.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// txtDateTimeOrdered
			// 
			this.txtDateTimeOrdered.AccessibleDescription = "Date Time Ordered";
			this.txtDateTimeOrdered.AccessibleName = "Date Time Ordered";
			this.txtDateTimeOrdered.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.txtDateTimeOrdered.Location = new System.Drawing.Point(140, 64);
			this.txtDateTimeOrdered.Name = "txtDateTimeOrdered";
			this.txtDateTimeOrdered.ReadOnly = true;
			this.txtDateTimeOrdered.ScrollBars = System.Windows.Forms.ScrollBars.Horizontal;
			this.txtDateTimeOrdered.Size = new System.Drawing.Size(182, 20);
			this.txtDateTimeOrdered.TabIndex = 5;
			this.txtDateTimeOrdered.Text = "";
			// 
			// txtOrderingClinician
			// 
			this.txtOrderingClinician.AccessibleDescription = "Ordering Clinician";
			this.txtOrderingClinician.AccessibleName = "Ordering Clinician";
			this.txtOrderingClinician.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.txtOrderingClinician.Location = new System.Drawing.Point(140, 16);
			this.txtOrderingClinician.Name = "txtOrderingClinician";
			this.txtOrderingClinician.ReadOnly = true;
			this.txtOrderingClinician.ScrollBars = System.Windows.Forms.ScrollBars.Horizontal;
			this.txtOrderingClinician.Size = new System.Drawing.Size(182, 20);
			this.txtOrderingClinician.TabIndex = 1;
			this.txtOrderingClinician.Text = "";
			// 
			// label17
			// 
			this.label17.Location = new System.Drawing.Point(8, 16);
			this.label17.Name = "label17";
			this.label17.TabIndex = 0;
			this.label17.Text = "Ordering Clinician";
			this.label17.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// txtSurgeryName
			// 
			this.txtSurgeryName.AccessibleDescription = "Pre Op Surgery Name";
			this.txtSurgeryName.AccessibleName = "Pre Op Surgery Name";
			this.txtSurgeryName.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.txtSurgeryName.Location = new System.Drawing.Point(140, 256);
			this.txtSurgeryName.Name = "txtSurgeryName";
			this.txtSurgeryName.ReadOnly = true;
			this.txtSurgeryName.ScrollBars = System.Windows.Forms.ScrollBars.Horizontal;
			this.txtSurgeryName.Size = new System.Drawing.Size(182, 20);
			this.txtSurgeryName.TabIndex = 21;
			this.txtSurgeryName.Text = "";
			// 
			// txtLabOrderID
			// 
			this.txtLabOrderID.AccessibleDescription = "V BECS Order ID";
			this.txtLabOrderID.AccessibleName = "V BECS Order ID";
			this.txtLabOrderID.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.txtLabOrderID.Location = new System.Drawing.Point(140, 160);
			this.txtLabOrderID.Name = "txtLabOrderID";
			this.txtLabOrderID.ReadOnly = true;
			this.txtLabOrderID.ScrollBars = System.Windows.Forms.ScrollBars.Horizontal;
			this.txtLabOrderID.Size = new System.Drawing.Size(182, 20);
			this.txtLabOrderID.TabIndex = 13;
			this.txtLabOrderID.Tag = "";
			this.txtLabOrderID.Text = "";
			// 
			// txtDiagnosis
			// 
			this.txtDiagnosis.AccessibleDescription = "Patient Admitting Diagnosis";
			this.txtDiagnosis.AccessibleName = "Patient Admitting Diagnosis";
			this.txtDiagnosis.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.txtDiagnosis.Location = new System.Drawing.Point(140, 208);
			this.txtDiagnosis.Name = "txtDiagnosis";
			this.txtDiagnosis.ReadOnly = true;
			this.txtDiagnosis.ScrollBars = System.Windows.Forms.ScrollBars.Horizontal;
			this.txtDiagnosis.Size = new System.Drawing.Size(182, 20);
			this.txtDiagnosis.TabIndex = 17;
			this.txtDiagnosis.Text = "";
			// 
			// txtDivision
			// 
			this.txtDivision.AccessibleDescription = "Patient Division";
			this.txtDivision.AccessibleName = "Patient Division";
			this.txtDivision.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.txtDivision.Location = new System.Drawing.Point(140, 232);
			this.txtDivision.Name = "txtDivision";
			this.txtDivision.ReadOnly = true;
			this.txtDivision.ScrollBars = System.Windows.Forms.ScrollBars.Horizontal;
			this.txtDivision.Size = new System.Drawing.Size(182, 20);
			this.txtDivision.TabIndex = 19;
			this.txtDivision.Text = "";
			// 
			// txtPatientTreating
			// 
			this.txtPatientTreating.AccessibleDescription = "Patient Treating Specialty";
			this.txtPatientTreating.AccessibleName = "Patient Treating Specialty";
			this.txtPatientTreating.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.txtPatientTreating.Location = new System.Drawing.Point(140, 184);
			this.txtPatientTreating.Name = "txtPatientTreating";
			this.txtPatientTreating.ReadOnly = true;
			this.txtPatientTreating.ScrollBars = System.Windows.Forms.ScrollBars.Horizontal;
			this.txtPatientTreating.Size = new System.Drawing.Size(182, 20);
			this.txtPatientTreating.TabIndex = 15;
			this.txtPatientTreating.Text = "";
			// 
			// label7
			// 
			this.label7.Location = new System.Drawing.Point(8, 256);
			this.label7.Name = "label7";
			this.label7.Size = new System.Drawing.Size(136, 23);
			this.label7.TabIndex = 20;
			this.label7.Text = "Pre-Op Surgery Name";
			this.label7.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// txtReason
			// 
			this.txtReason.AccessibleDescription = "Reason for Request";
			this.txtReason.AccessibleName = "Reason for Request";
			this.txtReason.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.txtReason.Location = new System.Drawing.Point(140, 304);
			this.txtReason.Multiline = true;
			this.txtReason.Name = "txtReason";
			this.txtReason.ReadOnly = true;
			this.txtReason.Size = new System.Drawing.Size(182, 36);
			this.txtReason.TabIndex = 25;
			this.txtReason.Text = "";
			// 
			// label4
			// 
			this.label4.Location = new System.Drawing.Point(8, 304);
			this.label4.Name = "label4";
			this.label4.Size = new System.Drawing.Size(120, 23);
			this.label4.TabIndex = 24;
			this.label4.Text = "Reason for Request";
			this.label4.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// label3
			// 
			this.label3.Location = new System.Drawing.Point(8, 232);
			this.label3.Name = "label3";
			this.label3.Size = new System.Drawing.Size(120, 23);
			this.label3.TabIndex = 18;
			this.label3.Text = "Patient Division";
			this.label3.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// label1
			// 
			this.label1.Location = new System.Drawing.Point(8, 208);
			this.label1.Name = "label1";
			this.label1.Size = new System.Drawing.Size(152, 23);
			this.label1.TabIndex = 16;
			this.label1.Text = "Patient Admitting Diagnosis";
			this.label1.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// label14
			// 
			this.label14.Location = new System.Drawing.Point(4, 96);
			this.label14.Name = "label14";
			this.label14.Size = new System.Drawing.Size(104, 20);
			this.label14.TabIndex = 6;
			this.label14.Text = "Date/Time Wanted";
			this.label14.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// txtSpecimenStatus
			// 
			this.txtSpecimenStatus.AccessibleDescription = "Specimen Status";
			this.txtSpecimenStatus.AccessibleName = "Specimen Status";
			this.txtSpecimenStatus.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.txtSpecimenStatus.Location = new System.Drawing.Point(124, 24);
			this.txtSpecimenStatus.Name = "txtSpecimenStatus";
			this.txtSpecimenStatus.ReadOnly = true;
			this.txtSpecimenStatus.ScrollBars = System.Windows.Forms.ScrollBars.Horizontal;
			this.txtSpecimenStatus.Size = new System.Drawing.Size(192, 20);
			this.txtSpecimenStatus.TabIndex = 3;
			this.txtSpecimenStatus.Text = "";
			// 
			// txtRequirements
			// 
			this.txtRequirements.AccessibleDescription = "Special Requirements";
			this.txtRequirements.AccessibleName = "Special Requirements";
			this.txtRequirements.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.txtRequirements.Location = new System.Drawing.Point(124, 48);
			this.txtRequirements.Name = "txtRequirements";
			this.txtRequirements.ReadOnly = true;
			this.txtRequirements.Size = new System.Drawing.Size(190, 20);
			this.txtRequirements.TabIndex = 5;
			this.txtRequirements.Text = "";
			// 
			// label8
			// 
			this.label8.Location = new System.Drawing.Point(4, 24);
			this.label8.Name = "label8";
			this.label8.Size = new System.Drawing.Size(120, 20);
			this.label8.TabIndex = 2;
			this.label8.Text = "Quantity";
			this.label8.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// label6
			// 
			this.label6.Location = new System.Drawing.Point(4, 24);
			this.label6.Name = "label6";
			this.label6.Size = new System.Drawing.Size(128, 20);
			this.label6.TabIndex = 2;
			this.label6.Text = "Specimen Status";
			this.label6.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// label5
			// 
			this.label5.Location = new System.Drawing.Point(4, 48);
			this.label5.Name = "label5";
			this.label5.Size = new System.Drawing.Size(120, 20);
			this.label5.TabIndex = 4;
			this.label5.Text = "Special Requirements";
			this.label5.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// lvPreviousResults
			// 
			this.lvPreviousResults.AccessibleDescription = "CPRS Order Lab Results";
			this.lvPreviousResults.AccessibleName = "CPRS Order Lab Results";
			this.lvPreviousResults.BackColor = System.Drawing.SystemColors.Control;
			this.lvPreviousResults.Columns.AddRange(new System.Windows.Forms.ColumnHeader[] {
																								this.colTestName,
																								this.colResult,
																								this.colDateTime});
			this.lvPreviousResults.Dock = System.Windows.Forms.DockStyle.Fill;
			this.lvPreviousResults.HideSelection = false;
			this.lvPreviousResults.Location = new System.Drawing.Point(3, 16);
			this.lvPreviousResults.MultiSelect = false;
			this.lvPreviousResults.Name = "lvPreviousResults";
			this.lvPreviousResults.Size = new System.Drawing.Size(318, 106);
			this.lvPreviousResults.TabIndex = 0;
			this.lvPreviousResults.View = System.Windows.Forms.View.Details;
			// 
			// colTestName
			// 
			this.colTestName.Text = "Test Name";
			this.colTestName.Width = 120;
			// 
			// colResult
			// 
			this.colResult.Text = "Test Result";
			this.colResult.Width = 80;
			// 
			// colDateTime
			// 
			this.colDateTime.Text = "Date/Time Verified";
			this.colDateTime.Width = 126;
			// 
			// label13
			// 
			this.label13.Location = new System.Drawing.Point(4, 0);
			this.label13.Name = "label13";
			this.label13.Size = new System.Drawing.Size(120, 20);
			this.label13.TabIndex = 0;
			this.label13.Text = "Component Class";
			this.label13.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// btnOK
			// 
			this.btnOK.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.btnOK.DialogResult = System.Windows.Forms.DialogResult.Cancel;
			this.btnOK.Location = new System.Drawing.Point(640, 385);
			this.btnOK.Name = "btnOK";
			this.btnOK.TabIndex = 0;
			this.btnOK.Text = "OK";
			this.btnOK.Click += new System.EventHandler(this.btnOK_Click);
			// 
			// pnlComponentClass
			// 
			this.pnlComponentClass.Controls.Add(this.label26);
			this.pnlComponentClass.Controls.Add(this.txtDateTimeWantedComponent);
			this.pnlComponentClass.Controls.Add(this.txtUrgencyComponent);
			this.pnlComponentClass.Controls.Add(this.label21);
			this.pnlComponentClass.Controls.Add(this.txtComments);
			this.pnlComponentClass.Controls.Add(this.label22);
			this.pnlComponentClass.Controls.Add(this.txtRequirements);
			this.pnlComponentClass.Controls.Add(this.txtComponent);
			this.pnlComponentClass.Controls.Add(this.label13);
			this.pnlComponentClass.Controls.Add(this.txtQuantity);
			this.pnlComponentClass.Controls.Add(this.label8);
			this.pnlComponentClass.Controls.Add(this.label5);
			this.pnlComponentClass.Dock = System.Windows.Forms.DockStyle.Fill;
			this.pnlComponentClass.Location = new System.Drawing.Point(3, 16);
			this.pnlComponentClass.Name = "pnlComponentClass";
			this.pnlComponentClass.Size = new System.Drawing.Size(318, 197);
			this.pnlComponentClass.TabIndex = 1;
			// 
			// label26
			// 
			this.label26.Location = new System.Drawing.Point(4, 96);
			this.label26.Name = "label26";
			this.label26.Size = new System.Drawing.Size(120, 20);
			this.label26.TabIndex = 8;
			this.label26.Text = "Date/Time Wanted";
			this.label26.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// txtDateTimeWantedComponent
			// 
			this.txtDateTimeWantedComponent.AccessibleDescription = "Date/Time Wanted";
			this.txtDateTimeWantedComponent.AccessibleName = "Date/Time Wanted";
			this.txtDateTimeWantedComponent.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.txtDateTimeWantedComponent.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.txtDateTimeWantedComponent.Location = new System.Drawing.Point(124, 96);
			this.txtDateTimeWantedComponent.Name = "txtDateTimeWantedComponent";
			this.txtDateTimeWantedComponent.ReadOnly = true;
			this.txtDateTimeWantedComponent.ScrollBars = System.Windows.Forms.ScrollBars.Horizontal;
			this.txtDateTimeWantedComponent.Size = new System.Drawing.Size(190, 20);
			this.txtDateTimeWantedComponent.TabIndex = 9;
			this.txtDateTimeWantedComponent.Text = "";
			// 
			// txtUrgencyComponent
			// 
			this.txtUrgencyComponent.AccessibleDescription = "Urgency";
			this.txtUrgencyComponent.AccessibleName = "Urgency";
			this.txtUrgencyComponent.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.txtUrgencyComponent.Location = new System.Drawing.Point(124, 120);
			this.txtUrgencyComponent.Name = "txtUrgencyComponent";
			this.txtUrgencyComponent.ReadOnly = true;
			this.txtUrgencyComponent.ScrollBars = System.Windows.Forms.ScrollBars.Horizontal;
			this.txtUrgencyComponent.Size = new System.Drawing.Size(190, 20);
			this.txtUrgencyComponent.TabIndex = 11;
			this.txtUrgencyComponent.Text = "";
			// 
			// label21
			// 
			this.label21.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.label21.Location = new System.Drawing.Point(4, 120);
			this.label21.Name = "label21";
			this.label21.Size = new System.Drawing.Size(120, 20);
			this.label21.TabIndex = 10;
			this.label21.Text = "Urgency";
			this.label21.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// txtComments
			// 
			this.txtComments.AccessibleDescription = "Order Comments";
			this.txtComments.AccessibleName = "Order Comments";
			this.txtComments.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.txtComments.Location = new System.Drawing.Point(124, 144);
			this.txtComments.Multiline = true;
			this.txtComments.Name = "txtComments";
			this.txtComments.ReadOnly = true;
			this.txtComments.Size = new System.Drawing.Size(190, 48);
			this.txtComments.TabIndex = 13;
			this.txtComments.Text = "";
			// 
			// label22
			// 
			this.label22.Location = new System.Drawing.Point(4, 144);
			this.label22.Name = "label22";
			this.label22.Size = new System.Drawing.Size(120, 20);
			this.label22.TabIndex = 12;
			this.label22.Text = "Order Comments";
			this.label22.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// grpOrderedProcedure
			// 
			this.grpOrderedProcedure.AccessibleDescription = "Order Request";
			this.grpOrderedProcedure.AccessibleName = "Order Request";
			this.grpOrderedProcedure.Controls.Add(this.pnlOrderedTest);
			this.grpOrderedProcedure.Controls.Add(this.pnlComponentClass);
			this.grpOrderedProcedure.Location = new System.Drawing.Point(60, 32);
			this.grpOrderedProcedure.Name = "grpOrderedProcedure";
			this.grpOrderedProcedure.Size = new System.Drawing.Size(324, 216);
			this.grpOrderedProcedure.TabIndex = 1;
			this.grpOrderedProcedure.TabStop = false;
			this.grpOrderedProcedure.Text = "Order Request";
			// 
			// pnlOrderedTest
			// 
			this.pnlOrderedTest.Controls.Add(this.txtUrgency);
			this.pnlOrderedTest.Controls.Add(this.txtOrderComments);
			this.pnlOrderedTest.Controls.Add(this.label23);
			this.pnlOrderedTest.Controls.Add(this.txtDiagnosticText);
			this.pnlOrderedTest.Controls.Add(this.label16);
			this.pnlOrderedTest.Controls.Add(this.txtSpecimenStatus);
			this.pnlOrderedTest.Controls.Add(this.label6);
			this.pnlOrderedTest.Controls.Add(this.txtSpecimenUID);
			this.pnlOrderedTest.Controls.Add(this.label14);
			this.pnlOrderedTest.Controls.Add(this.txtDateTimeWanted);
			this.pnlOrderedTest.Controls.Add(this.label20);
			this.pnlOrderedTest.Controls.Add(this.label24);
			this.pnlOrderedTest.Dock = System.Windows.Forms.DockStyle.Fill;
			this.pnlOrderedTest.Location = new System.Drawing.Point(3, 16);
			this.pnlOrderedTest.Name = "pnlOrderedTest";
			this.pnlOrderedTest.Size = new System.Drawing.Size(318, 197);
			this.pnlOrderedTest.TabIndex = 0;
			// 
			// txtUrgency
			// 
			this.txtUrgency.AccessibleDescription = "Urgency";
			this.txtUrgency.AccessibleName = "Urgency";
			this.txtUrgency.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.txtUrgency.Location = new System.Drawing.Point(124, 120);
			this.txtUrgency.Name = "txtUrgency";
			this.txtUrgency.ReadOnly = true;
			this.txtUrgency.ScrollBars = System.Windows.Forms.ScrollBars.Horizontal;
			this.txtUrgency.Size = new System.Drawing.Size(192, 20);
			this.txtUrgency.TabIndex = 9;
			this.txtUrgency.Text = "";
			// 
			// txtOrderComments
			// 
			this.txtOrderComments.AccessibleDescription = "Order Comments";
			this.txtOrderComments.AccessibleName = "Order Comments";
			this.txtOrderComments.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.txtOrderComments.Location = new System.Drawing.Point(124, 144);
			this.txtOrderComments.Multiline = true;
			this.txtOrderComments.Name = "txtOrderComments";
			this.txtOrderComments.ReadOnly = true;
			this.txtOrderComments.Size = new System.Drawing.Size(192, 48);
			this.txtOrderComments.TabIndex = 11;
			this.txtOrderComments.Text = "";
			// 
			// label23
			// 
			this.label23.Location = new System.Drawing.Point(4, 144);
			this.label23.Name = "label23";
			this.label23.Size = new System.Drawing.Size(100, 20);
			this.label23.TabIndex = 10;
			this.label23.Text = "Order Comments";
			this.label23.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// txtDiagnosticText
			// 
			this.txtDiagnosticText.AccessibleDescription = "Diagnostic Test";
			this.txtDiagnosticText.AccessibleName = "Diagnostic Test";
			this.txtDiagnosticText.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.txtDiagnosticText.Location = new System.Drawing.Point(124, 0);
			this.txtDiagnosticText.Name = "txtDiagnosticText";
			this.txtDiagnosticText.ReadOnly = true;
			this.txtDiagnosticText.Size = new System.Drawing.Size(192, 20);
			this.txtDiagnosticText.TabIndex = 0;
			this.txtDiagnosticText.Text = "";
			// 
			// label16
			// 
			this.label16.Location = new System.Drawing.Point(4, 0);
			this.label16.Name = "label16";
			this.label16.Size = new System.Drawing.Size(120, 20);
			this.label16.TabIndex = 0;
			this.label16.Text = "Diagnostic Test";
			this.label16.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// txtSpecimenUID
			// 
			this.txtSpecimenUID.AccessibleDescription = "Specimen UID";
			this.txtSpecimenUID.AccessibleName = "Specimen UID";
			this.txtSpecimenUID.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.txtSpecimenUID.Location = new System.Drawing.Point(124, 48);
			this.txtSpecimenUID.Name = "txtSpecimenUID";
			this.txtSpecimenUID.ReadOnly = true;
			this.txtSpecimenUID.ScrollBars = System.Windows.Forms.ScrollBars.Horizontal;
			this.txtSpecimenUID.Size = new System.Drawing.Size(192, 20);
			this.txtSpecimenUID.TabIndex = 5;
			this.txtSpecimenUID.Text = "";
			// 
			// label20
			// 
			this.label20.Location = new System.Drawing.Point(4, 48);
			this.label20.Name = "label20";
			this.label20.Size = new System.Drawing.Size(100, 20);
			this.label20.TabIndex = 4;
			this.label20.Text = "Specimen UID";
			this.label20.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// label24
			// 
			this.label24.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.label24.Location = new System.Drawing.Point(4, 120);
			this.label24.Name = "label24";
			this.label24.Size = new System.Drawing.Size(136, 20);
			this.label24.TabIndex = 8;
			this.label24.Text = "Urgency";
			this.label24.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// grpOrderCheck
			// 
			this.grpOrderCheck.AccessibleDescription = "CPRS Order Lab Results";
			this.grpOrderCheck.AccessibleName = "CPRS Order Lab Results";
			this.grpOrderCheck.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left)));
			this.grpOrderCheck.Controls.Add(this.lvPreviousResults);
			this.grpOrderCheck.Location = new System.Drawing.Point(60, 252);
			this.grpOrderCheck.Name = "grpOrderCheck";
			this.grpOrderCheck.Size = new System.Drawing.Size(324, 125);
			this.grpOrderCheck.TabIndex = 2;
			this.grpOrderCheck.TabStop = false;
			this.grpOrderCheck.Text = "CPRS Order Lab Results";
			// 
			// DlgOrderDetails
			// 
			this.AcceptButton = this.btnOK;
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.ClientSize = new System.Drawing.Size(720, 421);
			this.Controls.Add(this.grpOrderedProcedure);
			this.Controls.Add(this.grpOrderCheck);
			this.Controls.Add(this.btnOK);
			this.Controls.Add(this.groupBox2);
			this.Controls.Add(this.groupBox1);
			this.hlphelpChm.SetHelpKeyword(this, "Accept_Orders.htm");
			this.hlphelpChm.SetHelpNavigator(this, System.Windows.Forms.HelpNavigator.Topic);
			this.MaximizeBox = false;
			this.MinimizeBox = false;
			this.MinimumSize = new System.Drawing.Size(728, 448);
			this.Name = "DlgOrderDetails";
			this.RequiredFieldsLabel = true;
			this.hlphelpChm.SetShowHelp(this, true);
			this.Text = "VBECS - Order Details";
			this.Controls.SetChildIndex(this.groupBox1, 0);
			this.Controls.SetChildIndex(this.groupBox2, 0);
			this.Controls.SetChildIndex(this.btnOK, 0);
			this.Controls.SetChildIndex(this.grpOrderCheck, 0);
			this.Controls.SetChildIndex(this.lblRequiredField, 0);
			this.Controls.SetChildIndex(this.grpOrderedProcedure, 0);
			this.Controls.SetChildIndex(this.vbecsLogo1, 0);
			this.groupBox1.ResumeLayout(false);
			this.groupBox2.ResumeLayout(false);
			this.pnlComponentClass.ResumeLayout(false);
			this.grpOrderedProcedure.ResumeLayout(false);
			this.pnlOrderedTest.ResumeLayout(false);
			this.grpOrderCheck.ResumeLayout(false);
			this.ResumeLayout(false);

		}
		#endregion

		private void SetComponentProperties(BOL.PatientOrder patientOrder)
		{
			// CR 2693
			// hlpHelp
			// 
			this.hlpHelp.HelpNamespace = Environment.CurrentDirectory+"\\VBECS.chm";
			// 
			// hlphelpChm
			// 
			this.hlphelpChm.HelpNamespace = Environment.CurrentDirectory+"\\VBECS.chm";
			// 
			if (patientOrder is BOL.OrderedComponent) 
			{ 
				// set panels
				this.pnlComponentClass.Visible = true;
				this.pnlOrderedTest.Visible = false;

				// populate Ordered Component specific fields
				BOL.OrderedComponent oC = (BOL.OrderedComponent) patientOrder;
				this.txtComponent.Text = oC.ComponentOrdered.BloodComponentName;
				this.txtQuantity.Text			= oC.Quantity.ToString() + " Units";
				this.txtRequirements.Text		= oC.OrderSpecialInstructions;
				if (oC.RequiredDateTime != DateTime.MinValue)
				{
					//Sometimes we'll get date/time from VistA, sometimes just date.
					if (oC.RequiredDateTime.ToString("HH:mm") == "00:00")
					{
						this.txtDateTimeWantedComponent.Text = Common.VBECSDateTime.FormatDateString(oC.RequiredDateTime);
					}
					else
					{
						this.txtDateTimeWantedComponent.Text = Common.VBECSDateTime.FormatDateTimeString(oC.RequiredDateTime);
					}
				}
				this.txtUrgencyComponent.Text	= oC.OrderUrgencyText;
				// bnt removed ref to OrderComments and added OrderedComponentComments
				//this.txtComments.Text			= oC.OrderComments;
				this.txtComments.Text			= oC.OrderedComponentComments;
				this.txtCPRSOrderID.Text		= patientOrder.OrderGroupNumber;
				this.txtLabOrderID.Text			= oC.VBECSOrderNumber;
				this.txtLabOrderNo.Text			= oC.LabOrderNumber;
			}
			else
			{ 
				// set panels
				this.pnlOrderedTest.Visible = true;
				this.pnlComponentClass.Visible = false;

				// populate Ordered Test specific fields
				BOL.OrderedTest oT = (BOL.OrderedTest) patientOrder;
				this.txtDiagnosticText.Text = oT.OrderableTest; 
				this.txtSpecimenStatus.Text		= "Required"; // A specimen is always required for 
				
				this.txtSpecimenUID.Text		= oT.Specimen.SpecimenUid;
				if (oT.RequiredResultsDate != DateTime.MinValue)
				{
					//Sometimes we'll get date/time from VistA, sometimes just date.
					if (oT.RequiredResultsDate.ToString("HH:mm") == "00:00")
					{
						this.txtDateTimeWanted.Text		= Common.VBECSDateTime.FormatDateString(oT.RequiredResultsDate);
					}
					else
					{
						this.txtDateTimeWanted.Text		= Common.VBECSDateTime.FormatDateTimeString(oT.RequiredResultsDate);
					}
				}
				this.txtUrgency.Text			= oT.OrderUrgencyText;
				this.txtOrderComments.Text		= oT.OrderComments;
				this.txtCPRSOrderID.Text		= patientOrder.OrderGroupNumber;
				this.txtLabOrderID.Text			= oT.VBECSOrderNumber;
				this.txtLabOrderNo.Text			= oT.LabOrderNumber;
				this.txtOrderComments.Text			= oT.Comments;
			}

			// populate all other fields
			this.txtOrderingClinician.Text	= patientOrder.OrderingProviderLastName + ", " + patientOrder.OrderingProviderFirstName; 
			this.txtOrderingHospitalLocation.Text = patientOrder.OrderingHospitalLocation;
			this.txtDateTimeOrdered.Text	= Common.VBECSDateTime.FormatDateTimeString(patientOrder.OrderReceivedDateTime);
			this.txtOrderEnteredBy.Text		= patientOrder.OrderEnteredByLastName + ", " + patientOrder.OrderEnteredByFirstName;
			this.txtPatientTreating.Text	= patientOrder.TreatingSpecialtyName;
			this.txtDiagnosis.Text			= patientOrder.PatientAdmittingDiagnosis;
			this.txtDivision.Text			= ThisUser.CurrentDivisionRole.Division.DivisionName;
			this.txtSurgeryName.Text		= patientOrder.SurgeryName;
			if (patientOrder.InformedConsentIndicator == true) this.txtInformedConsent.Text = "Yes";
			else this.txtInformedConsent.Text = "No";
			this.txtReason.Text				= patientOrder.RequestReason;
		}

		private void PopulateListView(BOL.PatientOrder patientOrder)
		{
			DataTable dt = BOL.TestResult.GetTestResults(patientOrder.PatientOrderGuid);
			foreach (DataRow dr in dt.Rows)
			{
				ListViewItem lVI = new ListViewItem();

				lVI.Text = dr.IsNull(Common.VbecsTables.SpecimenTestThreshold.VistaLaboratoryTestName) ? string.Empty : dr[Common.VbecsTables.SpecimenTestThreshold.VistaLaboratoryTestName].ToString();
				lVI.SubItems.Add( dr.IsNull(Common.VbecsTables.PatientTest.TestResult) ? string.Empty : dr[Common.VbecsTables.PatientTest.TestResult].ToString() );
				lVI.SubItems.Add( dr.IsNull(Common.VbecsTables.PatientTest.ResultDateTime) ? string.Empty : Common.VBECSDateTime.FormatDateTimeString(System.Convert.ToDateTime(dr[Common.VbecsTables.PatientTest.ResultDateTime])));

				this.lvPreviousResults.Items.Add(lVI);
			}
		}

		private void btnOK_Click(object sender, System.EventArgs e)
		{
			this.Close();
		}

		
	}
}

